define(['app', 'angular', 'clampjs'], function (app, angular) {

	app.directive('lineClamp', function ($sanitize) {
		return {
			restrict: 'AE',
			require: 'ngModel',
			scope: {
				'lines': '=',
			},
			link: function(scope, elems, attrs, ngModelCtrl){
				ngModelCtrl.$render = function(){
					elems[0].innerHTML = $sanitize(ngModelCtrl.$viewValue);
					var clampedText = $clamp(elems[0], {clamp: parseInt(scope.lines), truncationChar: "...more", useNativeClamp: false}).clamped;
					if(clampedText !== undefined) {
						elems[0].innerHTML = clampedText.replace(/...more$/, "<span class='clamp-truncation'>...more</span>");
					}
				};
			}
		};
	});
});